<?LassoScript
/*
<fusedoc fuse="fbx_Settings.inc" language="Lasso" specification="3.0">
	<responsibilities>
		I set up the enviroment settings for this circuit. If this settings file is being inherited, then you can use VARIABLE to override
		a value set in a parent circuit or FBX_PARAM to accept a value set by a parent circuit
	</responsibilities>	
	<properties>
		<history author="Michael McKellip" email="mmckellip@lassofusebox.org" date="1/5/2003" type="create">
		<history author="Tami Williams" date="May 2003" email="tami@asktami.com" type="Update" />
		<history author="Tami Williams" date="May 2008" email="tami@asktami.com" type="Update" />
	</properties>
	<io>
		<in>
			<structure name="fusebox">
				<boolean name="isRootCircuit" comments="Is the circuit currently executing the root circuit?" />
			</structure>
		</in>
		<out>
			<string name="self" scope="variables" />
			<string name="SSL_self" scope="variables" />
			<string name="fuseaction" scope="variables" />
			<string name="gLoginMap" scope="variables" />
			<string name="appSiteMap" scope="variables" />
			<string name="debugflag" scope="variables" />
			<string name="debuginlineflag" scope="variables" />
			<string name="errckDbname" scope="variables" />
			<string name="errckTblname" scope="variables" />
			<string name="errckCode" scope="variables" />
			<string name="errckError" scope="variables" />
			<string name="errckFound" scope="variables" />
			<string name="errckAction" scope="variables" />
			<string name="errckActionStatement" scope="variables" />
			<string name="feedback" scope="variables" />
			<string name="logMessage" scope="variables" />
			<string name="valError" scope="variables" />
			<string name="isValid" scope="variables" />
			<string name="success" scope="variables" />
			<string name="XFA_ContactApp" scope="variables" />
			<string name="XFA_SimpsonFamily" scope="variables" />
			<string name="XFA_welcome" scope="variables" />
			<string name="XFA_loginform" scope="variables" />
			<string name="XFA_login" scope="variables" />
			<string name="XFA_secure" scope="variables" />
			<string name="XFA_logout" scope="variables" />
		</out>
	</io>
</fusedoc>
*/


var: 'self' ='index.lasso?fuseaction=' ;

var: 'appSiteMap' = (Map);
$appSiteMap->(Insert:'ghighlight'='#e5ebf4');
$appSiteMap->(Insert:'galtrowcolor'='#cf9');
$appSiteMap->(Insert:'gphone'='770-457-3221');
$appSiteMap->(Insert:'gYear'='2008');
$appSiteMap->(Insert:'gmailhost'='mail.asktami.com');
$appSiteMap->(Insert:'fromEmail'='lassofusebox@asktami.com');
$appSiteMap->(Insert:'gmailto'='lassofusebox@asktami.com');
$appSiteMap->(Insert:'gmailbcc'='lassofusebox@asktami.com');
$appSiteMap->(Insert:'gsitename'='LFB_Core_Files-Joined');
$appSiteMap->(Insert:'gSeed'='myEncryptionSeed');
$appSiteMap->(Insert:'FileUsername'='fusn');				//Username for file permissions outside root
$appSiteMap->(Insert:'FilePassword'='fpwd');				//Password for file permissions outside root

local:'temp' = '';
iterate: $appSiteMap, #temp ;
var: (#temp->first) = @($appSiteMap->(Find:(#temp->first)) );
/iterate;


/*
-------------------------------------------------------------------------------------------
REQUIRED VARS (do not remove)
-------------------------------------------------------------------------------------------
*/

var: 'debugflag' = 'N' ,							// debug	Y = display the debug vars from _common/dsp_debug.inc
'debuginlineflag' = 'N' ,						// debuginlineflag	Y = display the inline debug vars from _common/dsp_debuginline.inc
'errckDbname' = '' ,
'errckTblname' = '' ,
'errckCode' = (Error_NoError: -ErrorCode) ,
'errckError' = (Error_NoError) ,
'errckFound' = (integer) ,
'errckAction' = '' ,
'errckActionStatement' = '' ,
'feedback' = '',
'logMessage' = '',
'valError' =  (map) ,							// valError, isValid and success are used by val_ pages
'isValid' = '',
'success' = '' ;



FBX_Param: -Name='XFA_ContactApp', -Default= $self + 'ContactApp.list_Contacts' ;
FBX_Param: -Name='XFA_SimpsonFamily', -Default= $self + 'SimpsonFamily.main&frame=N' ;


FBX_Param: -Name='XFA_welcome', -Default= $self + 'home.welcome' ;
FBX_Param: -Name='XFA_loginform', -Default= $self + 'home.login_form' ;
FBX_Param: -Name='XFA_login', -Default= $self + 'home.login' ;
FBX_Param: -Name='XFA_secure', -Default= $self + 'secure.welcome' ;
FBX_Param: -Name='XFA_logout', -Default= $self + 'home.logout' ;


?>